// Xtimer_PWM mode.c - adapted for LPC97x/98x

// This example creates a PWM signal on port P0.3 using timer 2. 
// It sets up the mode 2 (PWM mode) and varies the duty cycle.
// The PWM signal can be observed by using an oscilloscope. 

// last update: 2010 March 10
 
#include <REG98x.h> 				
#include <stdio.h>

void msec(int x);
void init(void);
void Timer2_init(void);

unsigned char n=0;

// +++
 	
void main(void)
{
	P0M1 = 0x00;		// PushPull via P0.3
	P0M2 = 0x08;

	Timer2_init();		// set up timer2 in PWM	mode

 	while(1)
	{	
		for(n=1; n<99; n++) 	// vary duty cycle (1 => 99 %) of PWM
		{
			// Duty Cycle = RCAPxH:RCAPxL / (RCAPxH:RCAPxL + PWMDxH:PWMDxL)
			// see User Manual
			PWMD2H = n;
			PWMD2L = n;
			RCAP2H = n;
			RCAP2L = n;
			msec(15);			// delay
		}
		msec(100);		    
	
		for(n=99; n>1; n--)	// vary duty cycle (99 => 1 %) of PWM 
		{
			PWMD2H=n;
			PWMD2L=n;
			RCAP2H=n;
			RCAP2L=n;
			msec(15);		  	// delay
		}
		msec(100);				// delay
	}	// end of while(1)		
}		// end of main

void msec(int x)		// delay routine		 
{
	int j = 0;			// local var

	while(x >= 0)
	{
		for (j=0; j<135; j++);
		x--;
	}	
}

void Timer2_init(void)
{
	T2CON = 0x40;		// timer2:  PWM mode

	RCAP2H =  1;      // initialize the high period and low period
	RCAP2L =  1;
	PWMD2H =  1;
	PWMD2L =  1;
   T2CON  |= 0x14;	// start timer 2	            
}


